/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.util;

import com.mckoi.util.AbstractBlockIntegerList;
import com.mckoi.util.IntegerIterator;
import com.mckoi.util.IntegerListInterface;
import java.io.Serializable;

public final class IntegerVector
implements Serializable {
    protected int[] list;
    protected int index;

    public IntegerVector() {
        this(32);
    }

    public IntegerVector(int initial_list_size) {
        this.index = 0;
        this.list = new int[initial_list_size];
    }

    public IntegerVector(IntegerVector vec) {
        if (vec != null && vec.list != null) {
            this.list = new int[vec.list.length];
            this.index = vec.index;
            System.arraycopy(vec.list, 0, this.list, 0, this.index);
        } else {
            this.index = 0;
            this.list = new int[0];
        }
    }

    public IntegerVector(IntegerListInterface i_list) {
        this(i_list.size());
        if (i_list instanceof AbstractBlockIntegerList) {
            AbstractBlockIntegerList bilist = (AbstractBlockIntegerList)i_list;
            int bill_size = bilist.size();
            bilist.copyToArray(this.list, 0, bill_size);
            this.index = bill_size;
        } else {
            IntegerIterator i = i_list.iterator();
            while (i.hasNext()) {
                this.list[this.index] = i.next();
                ++this.index;
            }
        }
    }

    private void ensureCapacityForAddition() {
        if (this.index >= this.list.length) {
            int[] old_arr = this.list;
            int grow_size = old_arr.length + 1;
            if (grow_size > 35000) {
                grow_size = 35000;
            }
            int new_size = old_arr.length + grow_size;
            this.list = new int[new_size];
            System.arraycopy(old_arr, 0, this.list, 0, this.index);
        }
    }

    private void ensureCapacityForAdditions(int n) {
        int intended_size = this.index + n;
        if (intended_size > this.list.length) {
            int[] old_arr = this.list;
            int grow_size = old_arr.length + 1;
            if (grow_size > 35000) {
                grow_size = 35000;
            }
            int new_size = Math.max(old_arr.length + grow_size, intended_size);
            this.list = new int[new_size];
            System.arraycopy(old_arr, 0, this.list, 0, this.index);
        }
    }

    public void addInt(int val) {
        this.ensureCapacityForAddition();
        this.list[this.index] = val;
        ++this.index;
    }

    public void removeIntAt(int pos) {
        --this.index;
        System.arraycopy(this.list, pos + 1, this.list, pos, this.index - pos);
    }

    public void removeInt(int val) {
        int pos = this.indexOf(val);
        if (pos == -1) {
            throw new RuntimeException("Tried to remove none existant int.");
        }
        this.removeIntAt(pos);
    }

    public void crop(int start, int end) {
        if (start < 0) {
            throw new Error("Crop start < 0.");
        }
        if (start == 0) {
            if (end > this.index) {
                throw new Error("Crop end was past end.");
            }
            this.index = end;
        } else {
            if (start >= this.index) {
                throw new Error("start >= index");
            }
            int length = end - start;
            if (length < 0) {
                throw new Error("end - start < 0");
            }
            System.arraycopy(this.list, start, this.list, 0, length);
            this.index = length;
        }
    }

    public void insertIntAt(int val, int pos) {
        if (pos >= this.index) {
            throw new ArrayIndexOutOfBoundsException(pos + " >= " + this.index);
        }
        this.ensureCapacityForAddition();
        System.arraycopy(this.list, pos, this.list, pos + 1, this.index - pos);
        ++this.index;
        this.list[pos] = val;
    }

    public int setIntAt(int val, int pos) {
        if (pos >= this.index) {
            throw new ArrayIndexOutOfBoundsException(pos + " >= " + this.index);
        }
        int old = this.list[pos];
        this.list[pos] = val;
        return old;
    }

    public int placeIntAt(int val, int pos) {
        int llength = this.list.length;
        if (pos >= this.list.length) {
            this.ensureCapacityForAdditions(llength - this.index + (pos - llength) + 5);
        }
        if (pos >= this.index) {
            this.index = pos + 1;
        }
        int old = this.list[pos];
        this.list[pos] = val;
        return old;
    }

    public IntegerVector append(IntegerVector vec) {
        if (vec != null) {
            int size = vec.size();
            this.ensureCapacityForAdditions(size);
            System.arraycopy(vec.list, 0, this.list, this.index, size);
            this.index += size;
        }
        return this;
    }

    public int intAt(int pos) {
        if (pos >= this.index) {
            throw new ArrayIndexOutOfBoundsException(pos + " >= " + this.index);
        }
        return this.list[pos];
    }

    public int indexOf(int val) {
        for (int i = 0; i < this.index; ++i) {
            if (this.list[i] != val) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(int val) {
        return this.indexOf(val) != -1;
    }

    public int getSize() {
        return this.index;
    }

    public int size() {
        return this.index;
    }

    public int[] toIntArray() {
        if (this.getSize() != 0) {
            int[] out_list = new int[this.getSize()];
            System.arraycopy(this.list, 0, out_list, 0, this.getSize());
            return out_list;
        }
        return null;
    }

    public void clear() {
        this.index = 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.index; ++i) {
            buf.append(this.list[i]);
            buf.append(", ");
        }
        return new String(buf);
    }

    public boolean equals(IntegerVector ivec) {
        int dest_index = ivec.index;
        if (this.index != dest_index) {
            return false;
        }
        for (int i = 0; i < this.index; ++i) {
            if (this.list[i] == ivec.list[i]) continue;
            return false;
        }
        return true;
    }

    public void reverse() {
        int upper = this.index - 1;
        int bounds = this.index / 2;
        for (int i = 0; i < bounds; ++i) {
            int end_index = upper - i;
            int temp = this.list[i];
            this.list[i] = this.list[end_index];
            this.list[end_index] = temp;
        }
    }

    public final void quickSort(int min, int max) {
        int left = min;
        int right = max;
        if (max > min) {
            int mid = this.list[(min + max) / 2];
            while (left < right) {
                while (left < max && this.list[left] < mid) {
                    ++left;
                }
                while (right > min && this.list[right] > mid) {
                    --right;
                }
                if (left > right) continue;
                if (left != right) {
                    int t = this.list[left];
                    this.list[left] = this.list[right];
                    this.list[right] = t;
                }
                ++left;
                --right;
            }
            if (min < right) {
                this.quickSort(min, right);
            }
            if (left < max) {
                this.quickSort(left, max);
            }
        }
    }

    public final void quickSort() {
        this.quickSort(0, this.index - 1);
    }

    public final int sortedIndexOf(int val, int lower, int higher) {
        if (lower >= higher) {
            if (lower < this.index && val > this.list[lower]) {
                return lower + 1;
            }
            return lower;
        }
        int mid = (lower + higher) / 2;
        int mid_val = this.list[mid];
        if (val == mid_val) {
            return mid;
        }
        if (val < mid_val) {
            return this.sortedIndexOf(val, lower, mid - 1);
        }
        return this.sortedIndexOf(val, mid + 1, higher);
    }

    public final int sortedIndexOf(int val) {
        return this.sortedIndexOf(val, 0, this.index - 1);
    }

    public final int sortedIntCount(int val) {
        int temp_i;
        if (this.index == 0) {
            return 0;
        }
        int count = 0;
        int size = this.index - 1;
        int i = this.sortedIndexOf(val, 0, size);
        if (i > size) {
            return 0;
        }
        for (temp_i = i; temp_i >= 0 && this.list[temp_i] == val; --temp_i) {
            ++count;
        }
        for (temp_i = i + 1; temp_i <= size && this.list[temp_i] == val; ++temp_i) {
            ++count;
        }
        return count;
    }

    public boolean isSorted() {
        int cur = Integer.MIN_VALUE;
        for (int i = 0; i < this.index; ++i) {
            int a = this.list[i];
            if (a < cur) {
                return false;
            }
            cur = a;
        }
        return true;
    }
}

